/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.renyigesai.immortalers_delight.client.particle.ShockWaveParticleOption;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ShockWaveParticle
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static final float MAGICAL_X_ROT = 1.0472f;
    private int extra_size;
    private final SpriteSet spriteSet;

    ShockWaveParticle(ClientLevel pLevel, double pX, double pY, double pZ, SpriteSet spriteSet, int pSize) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.f_107663_ = 2.0f;
        this.extra_size = pSize;
        this.f_107225_ = 35;
        this.f_107226_ = 0.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.01;
        this.f_107217_ = 0.0;
        this.m_108339_(this.spriteSet);
    }

    public float m_5902_(float pScaleFactor) {
        float animation = Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f);
        float quadSize0 = 0.5f;
        float quadSize1 = 1.0f + (float)this.extra_size / 4.0f;
        float quadSize2 = quadSize1 - quadSize0;
        return this.f_107663_ * (ShockWaveParticle.easeOutExpo(animation) * quadSize2 + quadSize0);
    }

    public static float easeOutExpo(float t) {
        return t >= 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * t);
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        if (this.f_107224_ > this.f_107225_ / 2) {
            this.f_107230_ = 1.0f - Mth.m_14036_((float)(2.0f * ((float)this.f_107224_ - (float)(this.f_107225_ / 2) + pPartialTicks) / (float)this.f_107225_), (float)0.0f, (float)0.75f);
        }
        this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, p_253347_ -> p_253347_.mul((Quaternionfc)new Quaternionf().rotationX(-1.5707964f)));
        this.renderRotatedParticle(pBuffer, pRenderInfo, pPartialTicks, p_253346_ -> p_253346_.mul((Quaternionfc)new Quaternionf().rotationYXZ((float)(-Math.PI), 1.5707964f, 0.0f)));
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera pCamera, float pPartialTick, Consumer<Quaternionf> pQuaternion) {
        Vec3 vec3 = pCamera.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        pQuaternion.accept(quaternionf);
        quaternionf.transform(TRANSFORM_VECTOR);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(pPartialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(pPartialTick);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVertex, float pU, float pV, int pPackedLight) {
        pConsumer.m_5483_((double)pVertex.x(), (double)pVertex.y(), (double)pVertex.z()).m_7421_(pU, pV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(pPackedLight).m_5752_();
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (!this.f_107220_) {
            this.m_108337_(this.spriteSet.m_5819_(this.f_107224_ / 3 % 12 + 1, 12));
        }
    }

    public static ShockWaveParticleProvider shockWaveParticleProvider(SpriteSet sprite) {
        return new ShockWaveParticleProvider(sprite);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShockWaveParticleProvider
    implements ParticleProvider<ShockWaveParticleOption> {
        private final SpriteSet sprite;

        public ShockWaveParticleProvider(SpriteSet pSprite) {
            this.sprite = pSprite;
        }

        public Particle createParticle(ShockWaveParticleOption pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            ShockWaveParticle shockwaveparticle = new ShockWaveParticle(pLevel, pX, pY, pZ, this.sprite, pType.getCountdown());
            shockwaveparticle.m_107271_(1.0f);
            return shockwaveparticle;
        }
    }
}

